// Global Variables
let app = null;

// listen for messages from the user's current tab
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    // TODO: Implement this
    // User is browsing the web app and may click a thread link to open it while the extension is open.
    if(request?.action === 'cunext_prime_thread'){
        const thread_id = request?.thread_id || null;
        const url = request?.url || null;
        const chat_id = request?.chat_id || null;
        app.primeThread(thread_id, url, chat_id);
        // Respond with success
        sendResponse({success: true});
    }
});

$('document').ready(function(){

    // load icons from bsi
    render_bsi();

    // Initialize app state
    app = new AppState();
    app.applyFontSizeSetting();

    // Get current user url and load threads
    chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
        const currentTab = tabs[0];
        if (currentTab) {
            try{
                app.getThreads(currentTab.url);
            }catch(e){
                console.error(e);
            }
        }
    });

    // listeners
    $('#settings_opener').on('click',app.buildSettingsForm);
    $('#notifications_opener').on('click', function(){
        alert('Coming soon: Notifications!\n\nGet notified about new threads, replies, and updates from your followed users. Stay tuned for this exciting feature!');
    });
    $('#thread_locker').on('click', function(){
        if(app.toggleThreadLock()){ // locked if returns true
            $(this).empty().append('<span class="bi bi-unlock"></span>&nbsp;<span class="small">Unlock&nbsp;Thread</span>');
        }else{
            $(this).empty().append('<span class="bi bi-lock"></span>&nbsp;<span class="small">Lock&nbsp;Thread</span');
        }
        setTimeout(render_bsi,100);
    });

    // Track when the user's current url changes and load threads for the new page (new tab, new page, etc.)
    var setWebNavListeners = setInterval(() => {
        // app is loaded when page ready.
        if(!app) return; 
        if(!chrome || !chrome.webNavigation) return;

        // Monitor when a user navigates to a new page in the current tab
        chrome.webNavigation.onCompleted.addListener((details) => { 
            // app is loaded when page ready.
            if(!app) return; 
            chrome.tabs.get(details.tabId, (tab) => {
                // return if tab not active
                if(!tab.active) return;
                try{
                    app.getThreads(tab.url);
                }catch(e){
                    console.error(e);
                }
            });
        });

        // Add a listener for sites that use pushState to change the URL without reloading the page.
        chrome.webNavigation.onHistoryStateUpdated.addListener((details) => {
            // app is loaded when page ready.
            if(!app) return; 
            chrome.tabs.get(details.tabId, (tab) => {
                // return if tab not active
                if(!tab.active) return; 
                try{
                    app.getThreads(tab.url);
                }catch(e){
                    console.error(e);
                }
            });
        });
        clearInterval(setWebNavListeners);
        setWebNavListeners = null;
    },100);

    // Listen for navigation on current tab
    chrome.tabs.onActivated.addListener((activeInfo) => { 
        // app is loaded when page ready.
        if(!app) return; 
        chrome.tabs.get(activeInfo.tabId, (tab) => {
            // return if tab not active
            if(!tab.active) return;
            try{
                app.getThreads(tab.url);
            }catch(e){
                console.error(e);
            }
        });
    });

    // Listen for new tab creation
    chrome.tabs.onCreated.addListener((tab) => { 
        // app is loaded when page ready.
        if(!app) return; 
        // return if tab not active
        if(!tab.active) return;
        try{
            app.getThreads(tab.url);
        }catch(e){
            console.error(e);
        }
    });
});
